import { Queue } from 'bullmq';
import { Repository } from 'typeorm';
import { Order } from '../entities/order.entity';
import { Customer } from '../entities/customer.entity';
import { OrderDetail } from '../entities/order-detail.entity';
import { CreateOrderDto } from '../modules/orders/dto/create-order.dto';
import { Product } from '../entities/product.entity';
export declare class OrderService {
    private readonly orderRepo;
    private readonly customerRepo;
    private readonly orderDetailRepo;
    private readonly productRepo;
    private readonly orderQueue;
    constructor(orderRepo: Repository<Order>, customerRepo: Repository<Customer>, orderDetailRepo: Repository<OrderDetail>, productRepo: Repository<Product>, orderQueue: Queue);
    createOrder(dto: CreateOrderDto, customerId: string): Promise<Order>;
    getCustomerOrders(customerId: string): Promise<Order[]>;
    findOrderById(orderId: string, customerId: string): Promise<Order>;
}
